<?php
header('Content-Type: application/json');
require_once 'db.php';

$allowed = ['gihan', 'teah'];

$sender  = strtolower(trim($_POST['sender']  ?? ''));
$message = trim($_POST['message'] ?? '');

// Allow empty message only if not — validation stays simple
if (!in_array($sender, $allowed) || $message === '') {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Invalid input']);
    exit;
}

$stmt = $pdo->prepare('INSERT INTO messages (sender, message) VALUES (?, ?)');
$stmt->execute([$sender, $message]);

echo json_encode(['success' => true, 'id' => $pdo->lastInsertId()]);
