<?php
/**
 * mark_seen.php
 * Called by the frontend IntersectionObserver when received messages scroll into view.
 * Marks specific message IDs as 'seen'.
 */
header('Content-Type: application/json');
require_once 'db.php';

$allowed = ['gihan', 'teah'];
$viewer = strtolower(trim($_POST['viewer'] ?? ''));
$ids_raw = $_POST['ids'] ?? '';

if (!in_array($viewer, $allowed) || empty($ids_raw)) {
    http_response_code(400);
    echo json_encode(['success' => false]);
    exit;
}

// Parse and sanitize the ID list
$ids = array_filter(
    array_map('intval', explode(',', $ids_raw)),
    fn($id) => $id > 0
);

if (empty($ids)) {
    echo json_encode(['success' => true, 'updated' => 0]);
    exit;
}

$other = ($viewer === 'gihan') ? 'teah' : 'gihan';

// Only mark messages from the other person (viewer can't mark their own as seen)
$placeholders = implode(',', array_fill(0, count($ids), '?'));
$params = array_merge([$other], $ids);

$stmt = $pdo->prepare(
    "UPDATE messages SET status = 'seen'
     WHERE sender = ? AND id IN ($placeholders) AND status IN ('sent','delivered')"
);
$stmt->execute($params);

echo json_encode(['success' => true, 'updated' => $stmt->rowCount()]);
