<?php
/**
 * mark_delivered.php
 * Called by get_messages.php internally when a user fetches messages.
 * Marks all 'sent' messages from the OTHER user as 'delivered'.
 */
header('Content-Type: application/json');
require_once 'db.php';

$allowed = ['gihan', 'teah'];
$viewer = strtolower(trim($_POST['viewer'] ?? ''));

if (!in_array($viewer, $allowed)) {
    http_response_code(400);
    echo json_encode(['success' => false]);
    exit;
}

// The viewer is reading — so mark the sender's (other person's) messages as delivered
$other = ($viewer === 'gihan') ? 'teah' : 'gihan';

$stmt = $pdo->prepare(
    "UPDATE messages SET status = 'delivered'
     WHERE sender = ? AND status = 'sent'"
);
$stmt->execute([$other]);

echo json_encode(['success' => true, 'updated' => $stmt->rowCount()]);
