<?php
header('Content-Type: application/json');
require_once 'db.php';

$lastId = intval($_GET['last_id'] ?? 0);
$viewer = strtolower(trim($_GET['viewer'] ?? ''));

$allowed = ['gihan', 'teah'];
if (!in_array($viewer, $allowed)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid viewer']);
    exit;
}

// Mark the other person's 'sent' messages as 'delivered' since the viewer is online
$other = ($viewer === 'gihan') ? 'teah' : 'gihan';
$pdo->prepare(
    "UPDATE messages SET status = 'delivered' WHERE sender = ? AND status = 'sent'"
)->execute([$other]);

// Fetch new messages
$stmt = $pdo->prepare(
    'SELECT id, sender, message, file_path, file_type, status, sent_at
     FROM messages WHERE id > ? ORDER BY id ASC'
);
$stmt->execute([$lastId]);
$messages = $stmt->fetchAll();

echo json_encode(['messages' => $messages]);
