-- GTChat Database Setup
-- Run this in phpMyAdmin or MySQL CLI

CREATE DATABASE IF NOT EXISTS gtchat CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE gtchat;

CREATE TABLE IF NOT EXISTS messages (
    id         INT AUTO_INCREMENT PRIMARY KEY,
    sender     VARCHAR(20)  NOT NULL,
    message    TEXT         NOT NULL DEFAULT '',
    file_path  VARCHAR(300) NULL,
    file_type  ENUM('image','document') NULL,
    status     ENUM('sent','delivered','seen') NOT NULL DEFAULT 'sent',
    sent_at    DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ─── Migration: run these if the table already exists ──────────────────────
-- ALTER TABLE messages MODIFY message TEXT NOT NULL DEFAULT '';
-- ALTER TABLE messages ADD COLUMN file_path VARCHAR(300) NULL AFTER message;
-- ALTER TABLE messages ADD COLUMN file_type ENUM('image','document') NULL AFTER file_path;
-- ALTER TABLE messages ADD COLUMN status ENUM('sent','delivered','seen') NOT NULL DEFAULT 'sent' AFTER file_type;
-- ───────────────────────────────────────────────────────────────────────────

